/**
*    BouncingBall.cpp
*    
*    Extention of Routine to display a bouncing ball.
*    
*    Program written by Lopuz3
*    Spring 2013 
**/

#include "Arduino.h"
#include "BouncingBall.h"

BouncingBall::BouncingBall()
{
	ball = new Particle(random(CUBE_SIZE), random(CUBE_SIZE), CUBE_SIZE -1 -1, random(3,9), random(3,9), 0, true, 2, CUBE_SIZE);
}

void BouncingBall::update(unsigned long dt)
{
	float timeChange = 1.0*dt/1000000;
	ball->accelerateZ(-15, timeChange);
	ball->move(timeChange);
	for(byte x = 0 ; x < CUBE_SIZE ; x++)
	{
		for(byte y = 0 ; y < CUBE_SIZE ; y++)
		{
			for(byte z = 0 ; z < CUBE_SIZE ; z++)
			{
				cubeModel[x][y][z] = false;
			}
		}
	}
	
	for(byte x = 0 ; x < CUBE_SIZE ; x++)
	{
		for(byte y = 0 ; y < CUBE_SIZE ; y++)
		{
			for(byte z = 0 ; z < CUBE_SIZE ; z++)
			{
				cubeModel[x][y][z] = ball->pointIsInSphere(x, y, z);
			}
		}
	}
}	

BouncingBall::~BouncingBall()
{
	delete ball;
}